//=============================================================================
// SnowBall2.
//=============================================================================
class SnowBall2 extends SnowBall;

event HitWall(vector HitNormal, actor HitWall)
{
	local float speed;

	Velocity = 0.8*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	speed = VSize(Velocity);
	bFixedRotationDir = True;
	RotationRate = RotRand(False);
	if ((speed > 0) && (speed < 30) && (HitNormal.Z > 0.7))
	{
		SetPhysics(PHYS_None, HitWall);
		if (Physics == PHYS_None)
			bFixedRotationDir = False;
	}
	else if (speed > 30)
	{
		PlaySound(None, SLOT_None);
		AISendEvent('LoudNoise', EAITYPE_Audio);
	}
}

defaultproperties
{
     numThings=3
     HitPoints=13
     DrawScale=0.500000
     CollisionRadius=5.000000
     CollisionHeight=5.000000
     Mass=2.000000
}
